package javasposhmp;

import cz.cuni.pogamut.Client.RcvMsgEvent;
import cz.cuni.pogamut.Client.RcvMsgListener;
import cz.cuni.pogamut.MessageObjects.Player;
import cz.cuni.pogamut.MessageObjects.Triple;
import java.util.ArrayList;

import cz.cuni.pogamut.MessageObjects.AddWeapon;
import cz.cuni.pogamut.MessageObjects.Health;
import cz.cuni.pogamut.MessageObjects.Item;
import cz.cuni.pogamut.MessageObjects.MessageType;
import cz.cuni.pogamut.MessageObjects.Weapon;
import cz.cuni.pogamut.MessageObjects.PlayerKilled;
import cz.cuni.sposhBot.java.JavaBehaviour;
import cz.cuni.sposhBot.java.SPoshBot;

import java.util.logging.Logger;

/**
 * Here is the place to implement your acts and senses
 * The log domain of a behaviour is set to class name.
 *
 * act:
 *     in plan file: shoot
 *     in behaviour: public void action_shoot()
 * sense:
 *     in plan file: hear
 *     in behaviour: public boolean sense_hear()
 *
 * E.g. see action_doNothing() /  sense_fail()
 */
public class MyBehaviour extends JavaBehaviour {
    
    protected Item choosenItem = null;
    protected Item previousChoosenItem = null;
    public ArrayList<Item> itemsToRunAround = new ArrayList<Item>();
    public ArrayList<Item> medkitsToRunAround = null;
    protected ArrayList<Weapon> weaponsToCollect = null;
    Weapon runToWeap = null;
    KillListener weaponListener = new KillListener();
    AttackListener attackListener = new AttackListener();
    DeathListener deathListener = new DeathListener();
    boolean hasAllWeapons = false;
    Triple dodgeDirs[] = new Triple[3];
    

    protected boolean jumped = true;
    protected boolean medsRestart = true;
    private Player lastSeenEnemy;
	
    public MyBehaviour(String name, Logger log, SPoshBot bot) {
        super(name, log, bot);
        dodgeDirs[0] = new Triple(0, 1, 0);
        dodgeDirs[1] = new Triple(0, -1, 0);
        dodgeDirs[2] = new Triple(1, 0, 0);
    }
    /* Reset state, if bot dies*/
    private class DeathListener implements RcvMsgListener {
        public DeathListener() {
            bot.getBody().addTypedRcvMsgListener(this, MessageType.BOT_KILLED);
        }
        @Override
        public void receiveMessage(RcvMsgEvent e) {
            hasAllWeapons = false;
            medsRestart = true;
            runToWeap = null;
            log.severe("I AM DEAD");
        }
        
    }
    
    /* Change weapon, if bot receives it. Not used*/
    private class WeaponListener implements RcvMsgListener {
        public WeaponListener()
        {
            bot.getBody().addTypedRcvMsgListener(this, MessageType.ADD_WEAPON);
        }

        @Override
        public void receiveMessage(RcvMsgEvent e) {
            AddWeapon weapon = (AddWeapon)e.getMessage();
            if (weapon.ID == 0) {
                bot.getBody().changeWeapon(weapon);
                runToWeap = null;
            }
        }
    }
    
    /*If someone attacks the bot, find him. */
    private class AttackListener implements RcvMsgListener {
        public AttackListener()
        {
            bot.getBody().addTypedRcvMsgListener(this, MessageType.BOT_DAMAGED);
            bot.getBody().addTypedRcvMsgListener(this, MessageType.INCOMMING_PROJECTILE);
        }

        @Override
        public void receiveMessage(RcvMsgEvent e) {
            action_seekEnemy();
        }
    }
    
    private class KillListener implements RcvMsgListener {
        public KillListener()
        {
            bot.getBody().addTypedRcvMsgListener(this, MessageType.PLAYER_KILLED);
        }

        @Override
        public void receiveMessage(RcvMsgEvent e) {
            if (lastSeenEnemy.ID == ((PlayerKilled)(e.getMessage())).playerID)
            {
                log.severe("KILLED PLAYER: " + ((PlayerKilled)(e.getMessage())).toString());
                lastSeenEnemy = null;
                bot.getBody().stopShoot();
            }
        }
    }
    
    ArrayList<Weapon> getWeapons()
    {
        if (this.weaponsToCollect == null)
             weaponsToCollect = this.bot.getMemory().getKnownWeapons();
        return weaponsToCollect;
    }
    
    /*Choose a weapon of a type, bot doesn't have*/
    public boolean action_chooseWeaponToCollect(){
        log.info("Action ChooseWeaponToCollect.");
        ArrayList<Weapon> knownWeapons = getWeapons();
        for (Weapon w : knownWeapons)
        {
            if (this.bot.getMemory().hasWeaponOfType(w.weaponType)) {
                continue;
            }
            else {
                /* Prevents bot from standing on iventory spot,
                 * if the weapon isn't there, chooses another weapon*/
                if (Math.random() < 0.25)
                    continue;
                runToWeap = w;
                return true;
            }
        }
        for (Weapon w : knownWeapons)
        {
            if (this.bot.getMemory().hasWeaponOfType(w.weaponType)) {
                continue;
            }
            else {
                runToWeap = w;
                return true;
            }
        }
        bot.getBody().sendGlobalMessage("I've found all weapons");
        hasAllWeapons = true;
        return false;
    }
    
    
    /*Bot runs to selected weapon*/
    public boolean action_runToWeapon(){
        log.info("Action RunToWeapon");
        if (runToWeap == null) {
            log.severe("runToWeapon is null");
            return false;
        }
        if (!(bot.getMap().safeRunToLocation(runToWeap.location)))
        {
            runToWeap = null;
            return false;
        }
        if ((Triple.distanceInSpace(bot.getMemory().getAgentLocation(), runToWeap.location) < 100))
        {    
            runToWeap = null;
            return false;
        }
        return true;
    }
    
    /*If someone attacks us, we will find him*/
    public boolean action_seekEnemy(){
        if (lastSeenEnemy != null)
            bot.getBody().runToLocation(lastSeenEnemy.location);
        else 
        for (int i = 0; (i < 3) && (!bot.getMemory().getSeeAnyEnemy()); i++)
           bot.getBody().turnHorizontal(120);
        if (!bot.getMemory().getSeeAnyEnemy()) 
            return false;
        Player enemy = bot.getMemory().getSeeEnemy();
        bot.getBody().changeToBestWeapon();
        action_dodgeJump();
        bot.getBody().shoot(enemy);
        return true;
    }
    
    public boolean action_rearm() {
	this.log.info("Action REARM.");
        Player enemy = this.bot.getMemory().getSeeEnemy();
        if (enemy == null)
            return true;
    	AddWeapon weapon = this.bot.getMemory().getBetterWeapon(enemy.location, this.bot.getMemory().getAgentLocation());
    	this.bot.getBody().changeWeapon(weapon);
        action_dodgeJump();
        return true;
    }
    
    public boolean action_engageEnemy() {
	this.log.info("Action ENGAGE_ENEMY.");
        if (!bot.getMemory().hasAnyLoadedWeapon())
            return false;
        //if (bot.getMemory().isShooting())
        //    bot.getBody().stopShoot();
    	this.medsRestart = true;
        Player enemy = null;
        /* Check if last enemy is still in view*/
        if (lastSeenEnemy != null)
            enemy = this.bot.getMemory().getSeePlayer(lastSeenEnemy.UnrealID);
        else
            enemy = this.bot.getMemory().getSeeEnemy(); 
        
        //No enemy around
        if (enemy == null) {
            bot.getBody().stopShoot();
            if (lastSeenEnemy == null)
                return false;
            //Try to pursue last enemy
            bot.getBody().turnToLocation(lastSeenEnemy.location);
            if (bot.getMemory().getSeePlayer(lastSeenEnemy.UnrealID) != null)
                bot.getBody().shoot(lastSeenEnemy);
            if (!bot.getMap().safeRunToLocation(lastSeenEnemy.location))
                lastSeenEnemy = null;
            return true;
        }
        else
            lastSeenEnemy = enemy;
        //Get close eneough to the enemy
        if (this.bot.getMemory().getCurrentWeapon().effectiveDist/2 < Triple.distanceInSpace(this.bot.getMemory().getAgentLocation(),enemy.location))
            this.bot.getMap().safeRunToLocation(enemy.location);
        else 
            this.bot.getBody().stop();
    	this.bot.getBody().shoot(enemy);
        this.bot.getBody().turnToTarget(enemy);
        //action_dodgeJump();
        return true;
    }
    
    public boolean action_runAroundCloseMeds() {
	this.log.info("Action RUN_AROUND_CLOSE_MEDS.");    	
    	this.bot.getMap().runAroundItemsInTheMap(this.medkitsToRunAround, false);
        return true;
    }
    
   
    public void action_runAroundItems() {
	this.log.info("Action RUN_AROUND_ITEMS.");
    	this.bot.getMap().runAroundItemsInTheMap(this.itemsToRunAround, false);
    }
    
    public boolean action_runToItem() {
	this.log.info("Action RUN_TO_ITEM.");
        if(!this.bot.getMap().safeRunToLocation(choosenItem.location)) {
            // unable to reach the choosen item
            log.info("unable to REACH the choosen item");
            previousChoosenItem = choosenItem;
            choosenItem = null;
        }
        return true;
    }
    
    public boolean action_dodgeJump() {
        this.log.info("Action DODGE_JUMP.");
        //f (Math.random() < 0.5)
        //    this.bot.getBody().dodge(dodgeDirs[(int)(2*Math.random())]);
        this.bot.getBody().jump();
        return true;
    }
    
    public boolean action_stopShooting() {
	this.log.info("Action STOP_SHOOTING.");
    	this.bot.getBody().stopShoot();
        return true;
    }
    
    public boolean action_jump() {
        this.log.info("Action JUMP.");
        //If the bot is stuck somewhere, dodging to left or right might help
        if (Math.random() < 0.1)
            this.bot.getBody().dodge(dodgeDirs[(int)(2*Math.random())]);
        else
            this.bot.getBody().jump();
        return true;
    }
    
    /*public boolean action_doNothing() {
        return true;
     }*/
    
    @Override
    public boolean sense_fail() {
        return false;
    }
    
    @Override
    public boolean sense_succeed() {
        return true;
    }
    
    
    //Very slow movement -> stuck, or waiting, or firing enemy -> jump (in SPOSH plan)
    public boolean sense_stucked() {
        boolean ret = ((bot.getMemory().getAgentVelocity()).vectorSize() < 100);
        if (ret)
            log.info("STUCKED");
    	
        return ret;
    }
    
    public boolean sense_isShooting() {
    	return bot.getMemory().isShooting();
    }
    
    public boolean sense_isCollecting() {
        return (runToWeap != null);
    }
    
    public boolean sense_collectWeapons() {
        return !hasAllWeapons;
    }
    
    public boolean sense_hasAllWeapons() {
        return hasAllWeapons;
    }
    
    public boolean sense_hasBetterWeapon() {
        Triple botLoc = bot.getMemory().getAgentLocation();
        Player enemy = bot.getMemory().getSeeEnemy();
        if (enemy == null || enemy.location == null)
            return false;
    	AddWeapon candidate = bot.getMemory().getBetterWeapon(botLoc, enemy.location);
    	if (candidate != null)
    		return true;
    	else
    		return false;
    }
    
    public int sense_health() {    	
    	return bot.getMemory().getAgentHealth();
    }
    
    public boolean sense_knowMedkits() {
    	if (medsRestart)
    		this.medkitsToRunAround = null;
    	if (this.medkitsToRunAround != null)
    		return true;
    	ArrayList<Item> healths = this.bot.getMap().nearestHealth(15, 4);
    	if (healths == null || healths.size() < 2)
    		return false;
		this.medkitsToRunAround = healths;
		return true;
    }
    
    public boolean sense_beingAttacked()
    {
        return (bot.getMemory().isBeingDamaged() || bot.getMemory().isProjectileComming());
    }
    
    public boolean sense_armed() {
    	return bot.getMemory().hasAnyLoadedWeapon();
    }
    
    public boolean sense_seeEnemy() {
    	return bot.getMemory().getSeeAnyEnemy();
    }
    
    public boolean sense_seeItemAndWantIt() {
    	return this.seeAnyReachableItemAndWantIt();
    }
    
    //#############################################################
    // auxiliary functions
    //#############################################################

    
    /** 
     * choose weapon according to the one he is currently holding
     * <ol>
     * <li> has melee and see ranged => pick up ranged
     * <li> has ranged and see melee => pick up melee
     * <li> pick up first weapon he sees
     * </ol>
     * 
     * @return the choosen one weapon
     */
    private Weapon chooseWeapon() {
            ArrayList<Weapon> weapons = bot.getMemory().getSeeReachableWeapons();			
            for (Weapon weapon:weapons) {
                    // 0) has no weapon in hands
                    if (this.bot.getMemory().getCurrentWeapon() == null)
                            return weapon;
                    // 1) weapon is ranged, bot has melee
                    if ((this.bot.getMemory().getCurrentWeapon().melee) && !weapon.isMelee() && !this.bot.getMemory().hasWeaponOfType(weapon.weaponType)){
                            return weapon;
                    }
                    // 2) weapon is melee, bot has ranged
                    if (!this.bot.getMemory().getCurrentWeapon().melee && weapon.isMelee() && !this.bot.getMemory().hasWeaponOfType(weapon.weaponType)){
                            return weapon;
                    }
            }
            Weapon chosen = this.bot.getMemory().getSeeReachableWeapon();
            if (!this.bot.getMemory().hasWeaponOfType(chosen.weaponType)){
                    return chosen;
            }
            return null;
    }
	
    /**
     * Reasoning about what to do with seen item <br>
     * the easiest way of handeling it will be just to take it every time, but what should we do
     * when there are many of items laying in front of agent?
     * <ol>
     * <li> choose weapon - choose the type he is lacking (melee/ranged)
     * <li> choose armor
     * <li> choose health - if the health is bellow normal maximum
     * <li> choose ammo - if it is suitable for possessed weapons
     * <li> ignore the item
     * </ol>
     */
    private Item chooseItem() {
            // 1) choose weapon - choose the type he is lacking (melee/ranged)
            if (this.bot.getMemory().getSeeAnyReachableWeapon())
                    return chooseWeapon();
            // 2) choose armor
            if (this.bot.getMemory().getSeeAnyReachableArmor())
                    return this.bot.getMemory().getSeeReachableArmor();
            // 3) choose health - if the health is bellow normal maximum or the item is boostable
            if (this.bot.getMemory().getSeeAnyReachableHealth()) {
                    Health health = this.bot.getMemory().getSeeReachableHealth();
                    if (this.bot.getMemory().getAgentHealth() < 100)
                            return health;
                    if (health.boostable) // if the health item is boostable, grab it anyway:)
                            return health;
            }	
            // 4) choose ammo - if it is suitable for possessed weapons
            if ((this.bot.getMemory().getSeeAnyReachableAmmo()) && 
                    (this.bot.getMemory().isAmmoSuitable(this.bot.getMemory().getSeeReachableAmmo())))
                    return this.bot.getMemory().getSeeReachableAmmo();
            // 5) ignore the item
            return null;
    }

    /** 
     * sees reachable item and wants it
     * @return true if there is an item which is useful for agent
     */
    private boolean seeAnyReachableItemAndWantIt() {
            if (this.bot.getMemory().getSeeAnyReachableItem()){
                    choosenItem = chooseItem();
                    if (choosenItem != null) {
                            this.log.info("NEW ITEM CHOSEN: " + choosenItem);
                            this.log.info("LAST CHOOSEN ITEM: " + previousChoosenItem);
                    }
            } else {
                    choosenItem = null;
            }
            if ((choosenItem != null) && (!choosenItem.equals(previousChoosenItem)))
                //&& (Triple.distanceInSpace(memory.getAgentLocation(), choosenItem.location) > 20))
                return true;
            else
                return false;
    }

}